<?php
/*
Plugin Name: SM SpeedBoost Engine
Plugin URI: https://smarttoolhub.digital/
Description: Speed optimization: minify/combine CSS/JS, lazy images, WebP, caching, DB cleaner, preload, resource hints, GZIP, and per-page script removal.
Version: 1.0.0
Author: SmartToolHub
Author URI: https://smarttoolhub.digital/
License: GPLv2 or later
Text Domain: sm-speedboost-engine
*/

if (!defined('ABSPATH')) { exit; }

define('SMSPB_VER', '1.0.0');
define('SMSPB_FILE', __FILE__);
define('SMSPB_DIR', plugin_dir_path(__FILE__));
define('SMSPB_URL', plugins_url('', __FILE__));

require_once SMSPB_DIR . 'includes/util.php';
require_once SMSPB_DIR . 'includes/assets.php';
require_once SMSPB_DIR . 'includes/cache.php';
require_once SMSPB_DIR . 'includes/cron.php';
require_once SMSPB_DIR . 'includes/dbcleaner.php';

add_action('admin_menu', function(){
    add_menu_page('SM Speed', 'SM Speed', 'manage_options', 'sm-speed', function(){
        if (!current_user_can('manage_options')) { return; }
        if (isset($_POST['smspb_save']) && check_admin_referer('smspb_save')) {
            update_option('smspb_minify', isset($_POST['smspb_minify']) ? '1' : '0');
            update_option('smspb_combine', isset($_POST['smspb_combine']) ? '1' : '0');
            update_option('smspb_lazy', isset($_POST['smspb_lazy']) ? '1' : '0');
            update_option('smspb_webp', isset($_POST['smspb_webp']) ? '1' : '0');
            update_option('smspb_page_cache', isset($_POST['smspb_page_cache']) ? '1' : '0');
            update_option('smspb_browser_cache', isset($_POST['smspb_browser_cache']) ? '1' : '0');
            update_option('smspb_preload', isset($_POST['smspb_preload']) ? '1' : '0');
            update_option('smspb_defer_js', isset($_POST['smspb_defer_js']) ? '1' : '0');
            update_option('smspb_gzip', isset($_POST['smspb_gzip']) ? '1' : '0');
            update_option('smspb_prefetch', sanitize_text_field($_POST['smspb_prefetch'] ?? ''));
            echo '<div class="notice notice-success"><p>Settings saved.</p></div>';
        }
        $vals = [
            'minify'=>get_option('smspb_minify','0'),
            'combine'=>get_option('smspb_combine','0'),
            'lazy'=>get_option('smspb_lazy','0'),
            'webp'=>get_option('smspb_webp','0'),
            'page_cache'=>get_option('smspb_page_cache','0'),
            'browser_cache'=>get_option('smspb_browser_cache','0'),
            'preload'=>get_option('smspb_preload','0'),
            'defer_js'=>get_option('smspb_defer_js','0'),
            'gzip'=>get_option('smspb_gzip','0'),
            'prefetch'=>get_option('smspb_prefetch','')
        ];
        echo '<div class="wrap"><h1>SM SpeedBoost Engine</h1><form method="post">';
        wp_nonce_field('smspb_save');
        echo '<table class="form-table">';
        foreach ([
            ['smspb_minify','CSS/JS Minify'],
            ['smspb_combine','Combine CSS/JS'],
            ['smspb_lazy','Image Lazy Load'],
            ['smspb_webp','WebP Auto-Convert'],
            ['smspb_page_cache','Page Cache'],
            ['smspb_browser_cache','Browser Cache Headers'],
            ['smspb_preload','Preload Cache (Cron)'],
            ['smspb_defer_js','Defer JS'],
            ['smspb_gzip','GZIP Compression']
        ] as $row) {
            echo '<tr><th>' . esc_html($row[1]) . '</th><td><label><input type="checkbox" name="' . esc_attr($row[0]) . '" ' . checked('1', get_option($row[0],'0'), false) . ' /> Enable</label></td></tr>';
        }
        echo '<tr><th>DNS Prefetch Hosts</th><td><textarea name="smspb_prefetch" rows="3" class="large-text">' . esc_textarea($vals['prefetch']) . '</textarea><p class="description">One host per line.</p></td></tr>';
        echo '</table><p><button class="button button-primary" name="smspb_save" value="1">Save Settings</button></p></form></div>';
    }, 'dashicons-performance', 87);
});

add_action('add_meta_boxes', function(){
    foreach (['post','page'] as $pt) {
        add_meta_box('smspb_scripts', 'SM Speed: Per-page Scripts', function($post){
            $val = get_post_meta($post->ID, '_smspb_remove_scripts', true);
            echo '<p>Comma-separated script handles to remove.</p>';
            echo '<input type="text" name="smspb_remove_scripts" value="' . esc_attr($val) . '" class="widefat" />';
        }, $pt, 'side');
    }
});

add_action('save_post', function($post_id){
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;
    if (isset($_POST['smspb_remove_scripts'])) { update_post_meta($post_id, '_smspb_remove_scripts', sanitize_text_field($_POST['smspb_remove_scripts'])); }
});

add_action('init', function(){
    if (get_option('smspb_gzip','0')==='1' && !headers_sent()) { if (function_exists('ob_gzhandler')) { @ob_start('ob_gzhandler'); } }
});