<?php
if (!defined('ABSPATH')) { exit; }

function smspb_minify_css($css) { $css = preg_replace('/\/\*[^*]*\*+([^\/*][^*]*\*+)*\//', '', $css); $css = preg_replace('/\s+/', ' ', $css); $css = str_replace([' ;',' {',' }',' :',' ,'], [';','{','}',':',','], $css); return trim($css); }
function smspb_minify_js($js) { $js = preg_replace('/\/\*[^*]*\*+([^\/*][^*]*\*+)*\//', '', $js); $js = preg_replace('/(^|\s)//.*$/m', '', $js); $js = preg_replace('/\s+/', ' ', $js); return trim($js); }
function smspb_minify_html($html) { $html = preg_replace('/>\s+</','><',$html); return trim($html); }

function smspb_to_webp($path) {
    if (!function_exists('imagewebp')) return '';
    $info = @getimagesize($path); if (!$info) return '';
    $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
    $dest = $path . '.webp';
    if ($ext === 'jpg' || $ext === 'jpeg') { $img = @imagecreatefromjpeg($path); }
    elseif ($ext === 'png') { $img = @imagecreatefrompng($path); }
    else { return ''; }
    if (!$img) return '';
    imagepalettetotruecolor($img);
    imagealphablending($img, true);
    imagesavealpha($img, true);
    @imagewebp($img, $dest, 80);
    imagedestroy($img);
    return is_file($dest) ? $dest : '';
}