<?php
if (!defined('ABSPATH')) { exit; }

add_action('init', function(){
    if (get_option('smspb_preload','0')==='1' && !wp_next_scheduled('smspb_preload_event')) {
        wp_schedule_event(time()+300, 'hourly', 'smspb_preload_event');
    }
});

add_action('smspb_preload_event', function(){
    $urls = [home_url('/')];
    foreach ($urls as $u) { wp_remote_get($u, ['timeout'=>5]); }
});

add_filter('wp_resource_hints', function($hints, $relation){
    if ($relation === 'dns-prefetch') {
        $hosts = array_filter(array_map('trim', preg_split('/\r?\n/', get_option('smspb_prefetch',''))));
        foreach ($hosts as $h) { $hints[] = $h; }
    }
    return $hints;
}, 10, 2);