<?php
if (!defined('ABSPATH')) { exit; }

function smspb_cache_dir() {
    $upload = wp_upload_dir();
    $dir = trailingslashit($upload['basedir']) . 'sm-speed-cache';
    if (!is_dir($dir)) { wp_mkdir_p($dir); }
    return $dir;
}

add_action('template_redirect', function(){
    if (is_user_logged_in()) return;
    if (get_option('smspb_page_cache','0')!=='1') return;
    $key = md5(home_url(add_query_arg([], '')));
    $file = smspb_cache_dir() . '/' . $key . '.html';
    if (is_file($file) && (time() - filemtime($file)) < 3600) {
        $html = file_get_contents($file);
        echo $html; exit;
    }
    ob_start(function($buf) use ($file){
        if (get_option('smspb_minify','0')==='1') { $buf = smspb_minify_html($buf); }
        @file_put_contents($file, $buf);
        return $buf;
    });
});

add_action('send_headers', function(){
    if (get_option('smspb_browser_cache','0')==='1') {
        header('Cache-Control: public, max-age=86400');
    }
});