<?php
if (!defined('ABSPATH')) { exit; }

function smssl_run_full_scan() {
    $rep = ['files_changed'=>[], 'malware'=>[]];
    $base = ['wp-admin','wp-includes'];
    $hashes = get_option('smssl_core_hashes', []);
    foreach ($base as $dir) {
        $path = ABSPATH . $dir;
        if (!is_dir($path)) continue;
        $iter = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path, FilesystemIterator::SKIP_DOTS));
        foreach ($iter as $file) {
            if (!$file->isFile()) continue;
            $rel = $dir . '/' . str_replace('\\','/',substr($file->getPathname(), strlen($path)+1));
            $h = md5_file($file->getPathname());
            if (isset($hashes[$rel]) && $hashes[$rel] !== $h) { $rep['files_changed'][] = $rel; }
            $hashes[$rel] = $h;
        }
    }
    update_option('smssl_core_hashes', $hashes);
    $rep['malware'] = smssl_scan_malware();
    update_option('smssl_last_scan', time());
    if (!empty($rep['files_changed']) || !empty($rep['malware'])) { smssl_alert('Security scan alerts', 'Changes: ' . count($rep['files_changed']) . ', malware: ' . count($rep['malware'])); }
    return $rep;
}

function smssl_scan_malware() {
    $found = [];
    $dirs = [WP_CONTENT_DIR];
    $patterns = ['eval\s*\(','base64_decode\s*\(','gzinflate\s*\(','shell_exec\s*\(','passthru\s*\('];
    foreach ($dirs as $d) {
        if (!is_dir($d)) continue;
        $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($d, FilesystemIterator::SKIP_DOTS));
        foreach ($it as $f) {
            if ($f->isFile() && preg_match('/\.php$/i', $f->getFilename())) {
                $c = @file_get_contents($f->getPathname());
                foreach ($patterns as $p) { if (preg_match('/' . $p . '/i', $c)) { $found[] = str_replace('\\','/',$f->getPathname()); break; } }
            }
        }
    }
    return $found;
}

function smssl_render_report($rep) {
    echo '<h3>File Changes</h3><ul>'; foreach ($rep['files_changed'] as $r) { echo '<li>' . esc_html($r) . '</li>'; } echo '</ul>';
    echo '<h3>Malware</h3><ul>'; foreach ($rep['malware'] as $r) { echo '<li>' . esc_html($r) . '</li>'; } echo '</ul>';
}