<?php
if (!defined('ABSPATH')) { exit; }

function smssl_firewall_boot() {
    add_action('init', 'smssl_firewall_run', 0);
}

function smssl_firewall_run() {
    if (is_user_logged_in() && current_user_can('manage_options')) return;
    $patterns = [
        '/(\bUNION\b|\bSELECT\b|\bINSERT\b|\bUPDATE\b|\bDROP\b)/i',
        '/(<\s*script\b|onerror\s*=|onload\s*=|javascript:)/i',
        '/(\balert\s*\(|document\.|window\.)/i'
    ];
    $str = ($_SERVER['QUERY_STRING'] ?? '') . ' ' . ($_SERVER['REQUEST_URI'] ?? '') . ' ' . (file_get_contents('php://input') ?: '');
    foreach ($patterns as $re) { if (preg_match($re, $str)) { smssl_log_event('blocked', ['ip'=>smssl_get_ip()]); status_header(403); exit; } }
}