<?php
if (!defined('ABSPATH')) { exit; }

function smssl_run_backup() {
    global $wpdb;
    $upload = wp_upload_dir();
    $base = trailingslashit($upload['basedir']) . 'sm-secureshield';
    if (!is_dir($base)) { wp_mkdir_p($base); }
    $sqlPath = $base . '/db-' . date('Ymd-His') . '.sql';
    $zipPath = $base . '/wp-content-' . date('Ymd-His') . '.zip';
    $tables = $wpdb->get_col('SHOW TABLES');
    $out = '';
    foreach ($tables as $t) {
        $rows = $wpdb->get_results('SELECT * FROM `' . esc_sql($t) . '`', ARRAY_A);
        foreach ($rows as $row) {
            $cols = array_map(function($k){ return '`' . str_replace('`','``',$k) . '`'; }, array_keys($row));
            $vals = array_map(function($v){ return isset($v) ? ("'" . esc_sql(str_replace("'","\'", (string)$v)) . "'") : 'NULL'; }, array_values($row));
            $out .= 'INSERT INTO `' . $t . '` (' . implode(',', $cols) . ') VALUES (' . implode(',', $vals) . ');' . "\n";
        }
    }
    file_put_contents($sqlPath, $out);
    smssl_zip_dir(WP_CONTENT_DIR, $zipPath);
    smssl_log_event('backup', ['sql'=>$sqlPath,'zip'=>$zipPath]);
    return $zipPath;
}

function smssl_zip_dir($src, $zipFile) {
    if (!class_exists('ZipArchive')) return '';
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
        $src = realpath($src);
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($src, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::SELF_FIRST);
        foreach ($files as $file) {
            $file = realpath($file);
            if (is_dir($file)) { $zip->addEmptyDir(str_replace($src . '/', '', $file . '/')); }
            else if (is_file($file)) { $zip->addFile($file, str_replace($src . '/', '', $file)); }
        }
        $zip->close();
    }
    return $zipFile;
}