<?php
if (!defined('ABSPATH')) { exit; }

require_once ABSPATH . WPINC . '/feed.php';

function smabai_process_feeds(){
    $feeds = get_option('smabai_feeds', []);
    foreach ($feeds as $f) {
        $url = $f['url'] ?? ''; if ($url==='') continue;
        $rss = fetch_feed($url);
        if (is_wp_error($rss)) continue;
        $maxitems = $rss->get_item_quantity(10);
        $items = $rss->get_items(0, $maxitems);
        foreach ($items as $item) {
            $title = $item->get_title();
            $content = $item->get_content();
            $link = $item->get_link();
            $ok = smabai_match_keywords($title.' '.$content, $f['keywords'] ?? '');
            if (!$ok) continue;
            if (smabai_is_duplicate($title, $content)) continue;
            $rewrite = !empty($f['rewrite']);
            $final = $rewrite ? smabai_rewrite($content) : $content;
            smabai_create_post([ 'title'=>$title, 'content'=>$final, 'auto_publish'=>(!empty($f['auto_publish'])), 'prompt'=>($f['image_prompt']??''), 'source'=>$link ]);
        }
    }
}

function smabai_match_keywords($text, $kwcsv){
    $kws = array_filter(array_map('trim', explode(',', strtolower($kwcsv))));
    if (empty($kws)) return true;
    $t = strtolower($text);
    foreach ($kws as $k){ if ($k!=='' && strpos($t, $k)!==false) return true; }
    return false;
}

function smabai_import_url($url, $opts=[]){
    $resp = wp_remote_get($url, ['timeout'=>6]); if (is_wp_error($resp)) return false;
    $html = wp_remote_retrieve_body($resp);
    if (!$html) return false;
    preg_match('/<title>(.*?)<\/title>/is', $html, $mt); $title = !empty($mt[1]) ? wp_strip_all_tags($mt[1]) : 'Auto Post';
    preg_match('/<meta\s+name=\"description\"\s+content=\"([^\"]*)\"/i', $html, $md); $desc = !empty($md[1]) ? wp_strip_all_tags($md[1]) : '';
    $content = $desc !== '' ? $desc : smabai_clean_text($html);
    $content = substr($content, 0, 2000);
    if (smabai_is_duplicate($title, $content)) return false;
    $final = !empty($opts['rewrite']) ? smabai_rewrite($content) : $content;
    smabai_create_post([ 'title'=>$title, 'content'=>$final, 'auto_publish'=>true, 'prompt'=>'Auto image', 'source'=>$url ]);
    return true;
}

function smabai_create_post($data){
    list($cats,$tags) = smabai_detect_category_tags($data['content']);
    $status = !empty($data['auto_publish']) ? 'publish' : 'draft';
    $post_id = wp_insert_post([
        'post_title' => wp_strip_all_tags($data['title']),
        'post_content' => $data['content'],
        'post_status' => $status,
        'post_type' => 'post'
    ]);
    if (is_wp_error($post_id) || !$post_id) return false;
    $attach_id = smabai_generate_featured_image($data['title'], $data['prompt'] ?? '');
    if ($attach_id) { set_post_thumbnail($post_id, $attach_id); }
    foreach ($cats as $c) { $term = term_exists($c, 'category'); if (!$term) { $term = wp_insert_term($c, 'category'); } if (!is_wp_error($term)) { wp_set_post_terms($post_id, [(int)$term['term_id']], 'category', true); } }
    if (!empty($tags)) { wp_set_post_tags($post_id, $tags, true); }
    update_post_meta($post_id, '_smabai_quality', smabai_quality_score($data['content']));
    update_post_meta($post_id, '_smabai_source', esc_url_raw($data['source'] ?? ''));
    return $post_id;
}