<?php
if (!defined('ABSPATH')) { exit; }

function smaltai_clean_text($t){ $t = wp_strip_all_tags($t); $t = preg_replace('/\s+/',' ', $t); return trim($t); }
function smaltai_titlecase($t){ $t = strtolower($t); $t = preg_replace_callback('/\b([a-z])([a-z]*)\b/', function($m){ return strtoupper($m[1]) . $m[2]; }, $t); return trim($t); }
function smaltai_keywords($content){
    $text = strtolower(smaltai_clean_text($content));
    $text = preg_replace('/[^a-z0-9\s]/',' ', $text);
    $words = preg_split('/\s+/', $text, -1, PREG_SPLIT_NO_EMPTY);
    $stop = ['the','a','an','and','or','of','to','in','on','for','with','at','by','is','it','this','that','from','as','are','was','were','be','been','has','have','had','you','your','our'];
    $freq = [];
    foreach ($words as $w){ if (strlen($w)<3) continue; if (in_array($w,$stop,true)) continue; $freq[$w] = ($freq[$w] ?? 0) + 1; }
    arsort($freq);
    $out = array_keys($freq);
    if (empty($out)) { return []; }
    return array_slice($out, 0, 12);
}

?>